-- by "Marhu" 
-- v 1.0
-- Date: 10.05.2013
--"Register Fill Types only for loaded Map"

RegFillTypes = {};
RegFillTypes.dir = g_currentModDirectory
RegFillTypes.t = {};

--[[Fillable.registerFillType "fill"
--  name						name			string
--  nameI18N					I18N			string --in modDesc.xml der Map eingeben <l10n>
--  pricePerLiter,				price			float
--  partOfEconomy				Eco				bool
--  hudOverlayFilename			hud				string
]]

local HudDir = "Meyenburg/Schweinemast V2/"		--"map/Hud/"

table.insert(RegFillTypes.t, { name="pig", price=1, Eco=true, hud=HudDir.."pigHUD"});
table.insert(RegFillTypes.t, { name="pig1", price=0.001, Eco=true, hud=HudDir.."pig1HUD"});
table.insert(RegFillTypes.t, { name="pig2", price=0.001, Eco=true, hud=HudDir.."pig2HUD"});
table.insert(RegFillTypes.t, { name="pig3", price=0.001, Eco=true, hud=HudDir.."pig3HUD"});
table.insert(RegFillTypes.t, { name="pig4", price=0.001, Eco=true, hud=HudDir.."pig4HUD"});
table.insert(RegFillTypes.t, { name="pig5", price=0.001, Eco=true, hud=HudDir.."pig5HUD"});
table.insert(RegFillTypes.t, { name="pig6", price=0.001, Eco=true, hud=HudDir.."pig6HUD"});
table.insert(RegFillTypes.t, { name="beef", price=0.001, Eco=true, hud=HudDir.."beefHUD"});
table.insert(RegFillTypes.t, { name="beef1", price=0.001, Eco=true, hud=HudDir.."beef1HUD"});
table.insert(RegFillTypes.t, { name="beef2", price=0.001, Eco=true, hud=HudDir.."beef2HUD"});
table.insert(RegFillTypes.t, { name="beef3", price=0.001, Eco=true, hud=HudDir.."beef3HUD"});
table.insert(RegFillTypes.t, { name="beef4", price=0.001, Eco=true, hud=HudDir.."beef4HUD"});
table.insert(RegFillTypes.t, { name="beef5", price=0.001, Eco=true, hud=HudDir.."beef5HUD"});
table.insert(RegFillTypes.t, { name="beef6", price=0.001, Eco=true, hud=HudDir.."beef6HUD"});
---table.insert(RegFillTypes.t, { name="cow", price=0.1, Eco=true, hud=HudDir.."cowHUD"});
---table.insert(RegFillTypes.t, { name="cows", price=0.1, Eco=true, hud=HudDir.."cowsHUD"});
---table.insert(RegFillTypes.t, { name="sheep", price=0.05, Eco=true, hud=HudDir.."sheepHUD"});
---table.insert(RegFillTypes.t, { name="chickens", price=0.01, Eco=true, hud=HudDir.."chickenHUD"});
---table.insert(RegFillTypes.t, { name="flour", price=0.5, Eco=true, hud=HudDir.."flourHUD"});
---table.insert(RegFillTypes.t, { name="meat", price=0.5, Eco=true, hud=HudDir.."meatHUD"});

local org_FSBaseMission_loadMap = FSBaseMission.loadMap
FSBaseMission.loadMap = function(a, b, c, d, e)
	if a.baseDirectory == RegFillTypes.dir then
		RegFillTypes.MapName = a.missionInfo.map.title;
		local fill={}
		for i=1, table.getn(RegFillTypes.t) do
			local t = RegFillTypes.t[i];
			local HudFile = RegFillTypes.dir..t.hud..".dds";
			local I18N = t.I18N
			if I18N == nil then
				if g_i18n:hasText(t.name) then
					I18N = g_i18n:getText(t.name);
				else
					I18N = t.name;
				end;
			end;
			local FillType = Fillable.registerFillType(t.name,I18N,t.price,t.Eco,HudFile);
			if Fillable.fillTypeIndexToDesc[FillType] and Fillable.fillTypeIndexToDesc[FillType].nameI18N then
				FSBaseMission.addFillTypeOverlay(a,FillType,HudFile)
				--print("  Register fill type: ",Fillable.fillTypeIndexToDesc[FillType].nameI18N);
				table.insert(fill,Fillable.fillTypeIndexToDesc[FillType].nameI18N);
			else
				--print("  Register fill type: ",t.name," not nameI18N");
				table.insert(fill,t.name.." not nameI18N");
			end;
		end;

		local types = RegFillTypes.MapName..": Register Fill type: ";
		for k, v in pairs(fill) do
			types = types..v..", ";
		end;
		print(types)
	end;		
	ra,rb,rc,rd,re = org_FSBaseMission_loadMap(a, b, c, d, e)
	return ra,rb,rc,rd,re 
end





